/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.utils;

import eu.europa.ec.taxud.cesop.domain.DocTypeEnum;
import eu.europa.ec.taxud.cesop.domain.MessageTypeEnum;
import eu.europa.ec.taxud.cesop.domain.MessageTypeIndicEnum;
import eu.europa.ec.taxud.cesop.domain.TransactionDateEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationError;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorType;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorTypeEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorTypeHolder;
import eu.europa.ec.taxud.cesop.domain.XmlCountryTypeAndValue;
import eu.europa.ec.taxud.cesop.domain.XmlPsp;
import eu.europa.ec.taxud.cesop.domain.XmlTransactionDate;
import eu.europa.ec.taxud.cesop.domain.XmlTypeAndValue;
import eu.europa.ec.taxud.cesop.utils.IbanLength;
import eu.europa.ec.taxud.cesop.utils.LangUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ValidationErrorUtils {
    public static final DateTimeFormatter XML_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[.SSS]XXX").withResolverStyle(ResolverStyle.STRICT);
    private static final String XML_TIMESTAMP_FOR_QUARTER_FORMAT = "yyyy-MM";
    private static final DateTimeFormatter XML_DATE_TIME_FOR_QUARTER_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM");
    private static final Pattern IBAN_PATTERN = Pattern.compile("[A-Z]{2}[0-9]{2}[0-9A-Za-z]{10,30}");
    private static final BigInteger IBAN_DIVISOR = BigInteger.valueOf(97L);
    private static final BigInteger IBAN_REMAINDER = BigInteger.valueOf(1L);
    private static final Pattern BIC_PATTERN = Pattern.compile("^[a-z]{4}([a-z]{2})[a-z0-9]{2}([a-z0-9]{3})?$", 2);
    private static final String EU_COUNTRY_CODE = "EU";
    private static final String GREECE_EL = "EL";
    private static final String GREECE_GR = "GR";
    private static final String OTHER = "OTHER";
    private static final Set<String> GREECE_COUNTRY_CODES = Stream.of("GR", "EL").collect(Collectors.toSet());
    private static final Set<String> RP_BR_0090_IGNORE_VERSIONS = Stream.of("4.00", "4.01", "4.02").collect(Collectors.toSet());
    private static final Set<String> RP_BR_0100_IGNORE_VERSIONS = Stream.of("4.00", "4.01", "4.02").collect(Collectors.toSet());
    private static final Set<String> RP_BR_0110_IGNORE_VERSIONS = Stream.of("4.00", "4.01", "4.02").collect(Collectors.toSet());
    private static final Set<String> CM_BR_0120_IGNORE_VERSIONS = Stream.of("4.00", "4.01", "4.02").collect(Collectors.toSet());
    private static final Set<String> CM_BR_0130_IGNORE_VERSIONS = Stream.of("4.00", "4.01", "4.02").collect(Collectors.toSet());
    private static final Set<String> CM_BR_0140_IGNORE_VERSIONS = Stream.of("4.00", "4.01", "4.02").collect(Collectors.toSet());

    private ValidationErrorUtils() {
    }

    public static void checkMhBr0070AndMhBr0080(List<ValidationError> validationErrors, String messageRefId, MessageTypeIndicEnum messageTypeIndic, DocTypeEnum docType, String docRefId) {
        if (messageTypeIndic == MessageTypeIndicEnum.CESOP100 && docType != DocTypeEnum.CESOP1) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.MH_BR_0070, messageRefId, docRefId, null));
        } else if (messageTypeIndic == MessageTypeIndicEnum.CESOP101 && docType == DocTypeEnum.CESOP1) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.MH_BR_0080, messageRefId, docRefId, null));
        }
    }

    public static void checkCmBr0010(List<ValidationError> validationErrors, String messageRefId, Set<String> docRefIds, String docRefId) {
        if (!docRefIds.add(docRefId)) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_BR_0010, messageRefId, docRefId, null));
        }
    }

    public static void checkCmBr0050(List<ValidationError> validationErrors, String messageRefId, DocTypeEnum docTypeEnum, String corrDocRefId, String docRefId) {
        if (docTypeEnum == DocTypeEnum.CESOP1 && LangUtils.isNotBlank(corrDocRefId)) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_BR_0050, messageRefId, docRefId, null));
        }
    }

    public static void checkCmBr0060(List<ValidationError> validationErrors, String messageRefId, DocTypeEnum docTypeEnum, String corrDocRefId, String docRefId) {
        if ((docTypeEnum == DocTypeEnum.CESOP2 || docTypeEnum == DocTypeEnum.CESOP3) && LangUtils.isBlank(corrDocRefId)) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_BR_0060, messageRefId, docRefId, null));
        }
    }

    public static void checkCmBr0120(List<ValidationError> validationErrors, String messageRefId, DocTypeEnum docTypeEnum, String corrDocRefId, Set<String> corrDocRefIds, String xsdVersion, String docRefId) {
        if (!(CM_BR_0120_IGNORE_VERSIONS.contains(xsdVersion) || docTypeEnum != DocTypeEnum.CESOP2 && docTypeEnum != DocTypeEnum.CESOP3 || corrDocRefId == null || corrDocRefIds == null || corrDocRefIds.contains(corrDocRefId))) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_BR_0120, messageRefId, docRefId, null));
        }
    }

    public static void checkRpBr0010(List<ValidationError> validationErrors, String messageRefId, String payeeCountry, String payerMsCountry, String transactionIdentifier) {
        if (Objects.equals(payeeCountry, payerMsCountry)) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0010, messageRefId, null, transactionIdentifier));
        }
    }

    public static boolean checkRpBr0020(List<ValidationError> validationErrors, String messageRefId, String accountIdentifierType, String iban, String docRefId) {
        if ("IBAN".equalsIgnoreCase(accountIdentifierType) && (iban == null || !IBAN_PATTERN.matcher(iban).matches())) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0020, messageRefId, docRefId, null));
            return false;
        }
        return true;
    }

    public static void checkRpBr0030(List<ValidationError> validationErrors, String messageRefId, String accountIdentifierType, String iban, String docRefId) {
        if (!"IBAN".equalsIgnoreCase(accountIdentifierType) || iban == null || iban.length() < 2 || LangUtils.isBlank(iban.substring(0, 2))) {
            return;
        }
        String countryCode = iban.substring(0, 2);
        Integer ibanLength = IbanLength.findForCountry(countryCode);
        if (ibanLength == null || ibanLength == 0) {
            return;
        }
        if (iban.length() != ibanLength.intValue()) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0030, messageRefId, docRefId, null));
        } else {
            int index;
            char[] chars = iban.toCharArray();
            StringBuilder sb = new StringBuilder(ibanLength * 2);
            for (index = 4; index < ibanLength; ++index) {
                sb.append(Character.getNumericValue(chars[index]));
            }
            for (index = 0; index < 4; ++index) {
                sb.append(Character.getNumericValue(chars[index]));
            }
            BigInteger ibanInteger = new BigInteger(sb.toString());
            if (ibanInteger.mod(IBAN_DIVISOR).compareTo(IBAN_REMAINDER) != 0) {
                validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0030, messageRefId, docRefId, null));
            }
        }
    }

    public static void checkRpBr0040(List<ValidationError> validationErrors, String messageRefId, boolean hasPaymentData, MessageTypeIndicEnum messageTypeIndic) {
        if (messageTypeIndic == MessageTypeIndicEnum.CESOP102 && hasPaymentData) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0040, messageRefId));
        }
    }

    public static void checkRpBr0050(List<ValidationError> validationErrors, String messageRefId, DocTypeEnum docType, boolean emptyTransactions) {
        if (docType != DocTypeEnum.CESOP3 && emptyTransactions) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0050, messageRefId));
        }
    }

    public static void checkRpBr0060(List<ValidationError> validationErrors, XmlCountryTypeAndValue account, String messageRefId) {
        if (LangUtils.isNotBlank(account.getValue())) {
            if (LangUtils.isBlank(account.getCountry()) || LangUtils.isBlank(account.getType())) {
                validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0060, messageRefId));
            }
        } else if (LangUtils.isNotBlank(account.getCountry()) || LangUtils.isNotBlank(account.getType())) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0060, messageRefId));
        }
    }

    public static void checkMhBr0030(List<ValidationError> validationErrors, String messageRefId, Integer period, Integer minPeriod) {
        if (period < minPeriod) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.MH_BR_0030, messageRefId));
        }
    }

    public static void checkMhBr0090(List<ValidationError> validationErrors, String messageRefId, MessageTypeEnum messageType, boolean hasPaymentDataBody) {
        if (messageType != MessageTypeEnum.PMT || !hasPaymentDataBody) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.MH_BR_0090, messageRefId));
        }
    }

    public static void checkMhBr0100(List<ValidationError> validationErrors, String messageRefId, MessageTypeIndicEnum messageTypeIndic, Integer period, Integer correlatedPeriod) {
        if (messageTypeIndic == MessageTypeIndicEnum.CESOP101 && !period.equals(correlatedPeriod)) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.MH_BR_0100, messageRefId));
        }
    }

    public static void checkMhBr0110(List<ValidationError> validationErrors, String messageRefId, String corrMessageRefId, MessageTypeIndicEnum messageTypeIndic) {
        if (LangUtils.isNotBlank(corrMessageRefId) && messageTypeIndic != MessageTypeIndicEnum.CESOP101 || LangUtils.isBlank(corrMessageRefId) && messageTypeIndic == MessageTypeIndicEnum.CESOP101) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.MH_BR_0110, messageRefId));
        }
    }

    public static void checkMhBr0120(List<ValidationError> validationErrors, String messageRefId, String transmittingCountry, String requiredCountry) {
        if (LangUtils.isBlank(requiredCountry)) {
            return;
        }
        if (EU_COUNTRY_CODE.equalsIgnoreCase(requiredCountry)) {
            return;
        }
        if (requiredCountry.equalsIgnoreCase(transmittingCountry)) {
            return;
        }
        if (GREECE_COUNTRY_CODES.contains(requiredCountry) && GREECE_COUNTRY_CODES.contains(transmittingCountry)) {
            return;
        }
        validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.MH_BR_0120, messageRefId));
    }

    public static void checkRtBr0010(List<ValidationError> validationErrors, String messageRefId, boolean isRefund, XmlTypeAndValue amount, String transactionIdentifier) {
        BigDecimal decimal = new BigDecimal(amount.getValue());
        if (isRefund && BigDecimal.ZERO.compareTo(decimal) < 0 || !isRefund && BigDecimal.ZERO.compareTo(decimal) > 0) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RT_BR_0010, messageRefId, null, transactionIdentifier));
        }
    }

    public static void checkRtBr0030(List<ValidationError> validationErrors, String messageRefId, Integer period, EnumMap<TransactionDateEnum, XmlTransactionDate> dates, String transactionIdentifier) {
        for (XmlTransactionDate date : dates.values()) {
            String yearMonth = date.getDate().substring(0, XML_TIMESTAMP_FOR_QUARTER_FORMAT.length());
            TemporalAccessor temporalAccessor = XML_DATE_TIME_FOR_QUARTER_FORMAT.parse(yearMonth);
            int year = temporalAccessor.get(ChronoField.YEAR);
            int quarter = temporalAccessor.get(IsoFields.QUARTER_OF_YEAR);
            int datePeriod = year * 10 + quarter;
            if (period != datePeriod) continue;
            return;
        }
        validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RT_BR_0030, messageRefId, null, transactionIdentifier));
    }

    public static void checkRtBr0040(List<ValidationError> validationErrors, String messageRefId, Set<String> transactionIdentifiers, String transactionIdentifier) {
        if (!transactionIdentifiers.add(transactionIdentifier)) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RT_BR_0040, messageRefId, null, transactionIdentifier));
        }
    }

    public static void checkRtBr0060(List<ValidationError> validationErrors, String messageRefId, String amount, String transactionIdentifier) {
        BigDecimal decimal = new BigDecimal(amount);
        if (BigDecimal.ZERO.compareTo(decimal) == 0) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RT_BR_0060, messageRefId, null, transactionIdentifier));
        }
    }

    public static void checkRtBr0080(List<ValidationError> validationErrors, String messageRefId, boolean isInErrorRtBr0080, String transactionIdentifier) {
        if (isInErrorRtBr0080) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RT_BR_0080, messageRefId, null, transactionIdentifier));
        }
    }

    public static void checkRtBr0090(List<ValidationError> validationErrors, String messageRefId, boolean isRefund, String transactionIdentifier, String corrTransactionIdentifier) {
        if (!isRefund && LangUtils.isNotBlank(corrTransactionIdentifier)) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RT_BR_0090, messageRefId, null, transactionIdentifier));
        }
    }

    public static void checkCmTr0020(List<ValidationError> validationErrors, String messageRefId) {
        validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_TR_0020, messageRefId));
    }

    public static void checkCmTr0030(List<ValidationError> validationErrors, String messageRefId) {
        validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_TR_0030, messageRefId));
    }

    public static void checkCmTr0040(List<ValidationError> validationErrors, String messageRefId) {
        validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_TR_0040, messageRefId));
    }

    public static void checkCmTr0050(List<ValidationError> validationErrors, String messageRefId) {
        validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_TR_0050, messageRefId));
    }

    public static void checkCmTr0060(List<ValidationError> validationErrors, String messageRefId) {
        validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_TR_0060, messageRefId));
    }

    public static void checkCmTr0070(List<ValidationError> validationErrors, String messageRefId, long size, long maxSize) {
        if (size > maxSize) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_TR_0070, messageRefId));
        }
    }

    public static void checkCmBr0110(List<ValidationError> validationErrors, String messageRefId, MessageTypeIndicEnum messageTypeIndic) {
        if (messageTypeIndic != MessageTypeIndicEnum.CESOP101 && messageTypeIndic != MessageTypeIndicEnum.CESOP102) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_BR_0110, messageRefId));
        }
    }

    public static void checkRpBr0070(List<ValidationError> validationErrors, String messageRefId, XmlTypeAndValue representativeId, String docRefId) {
        ValidationErrorUtils.checkBicFormat(validationErrors, messageRefId, representativeId, ValidationErrorTypeEnum.RP_BR_0070, docRefId);
    }

    public static void checkCmBr0100(List<ValidationError> validationErrors, String messageRefId, XmlTypeAndValue pspId) {
        ValidationErrorUtils.checkBicFormat(validationErrors, messageRefId, pspId, ValidationErrorTypeEnum.CM_BR_0100, null);
    }

    public static void checkCmBr0130(List<ValidationError> validationErrors, String messageRefId, String type, String other, String xsdVersion) {
        if (CM_BR_0130_IGNORE_VERSIONS.contains(xsdVersion)) {
            return;
        }
        if (OTHER.equalsIgnoreCase(type) && LangUtils.isBlank(other) || !OTHER.equalsIgnoreCase(type) && LangUtils.isNotBlank(other)) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_BR_0130, messageRefId));
        }
    }

    public static void checkCmBr0140(List<ValidationError> validationErrors, String messageRefId, String type, String other, String xsdVersion) {
        if (CM_BR_0140_IGNORE_VERSIONS.contains(xsdVersion)) {
            return;
        }
        if (OTHER.equalsIgnoreCase(type) && LangUtils.isBlank(other) || !OTHER.equalsIgnoreCase(type) && LangUtils.isNotBlank(other)) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_BR_0140, messageRefId));
        }
    }

    public static void checkCmBr0140ForDates(List<ValidationError> validationErrors, String messageRefId, Map<TransactionDateEnum, XmlTransactionDate> dates, String xsdVersion) {
        if (CM_BR_0140_IGNORE_VERSIONS.contains(xsdVersion)) {
            return;
        }
        if (dates != null) {
            for (Map.Entry<TransactionDateEnum, XmlTransactionDate> entry : dates.entrySet()) {
                if ((!TransactionDateEnum.OTHER_DATE.equals((Object)entry.getKey()) || !LangUtils.isBlank(entry.getValue().getOther())) && (TransactionDateEnum.OTHER_DATE.equals((Object)entry.getKey()) || !LangUtils.isNotBlank(entry.getValue().getOther()))) continue;
                validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_BR_0140, messageRefId));
                return;
            }
        }
    }

    private static void checkBicFormat(List<ValidationError> validationErrors, String messageRefId, XmlTypeAndValue id, ValidationErrorTypeEnum errorType, String docRefId) {
        if ("BIC".equalsIgnoreCase(id.getType())) {
            Matcher matcher = BIC_PATTERN.matcher(id.getValue());
            if (matcher.matches()) {
                if (IbanLength.findForCountry(matcher.group(1)) == null) {
                    validationErrors.add(ValidationErrorUtils.createValidationError(errorType, messageRefId, docRefId, null));
                }
            } else {
                validationErrors.add(ValidationErrorUtils.createValidationError(errorType, messageRefId, docRefId, null));
            }
        }
    }

    public static void checkRpBr0080(List<ValidationError> validationErrors, String messageRefId, XmlCountryTypeAndValue accountIdentifier, XmlPsp representative, String docRefId) {
        if (accountIdentifier == null == (representative == null)) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0080, messageRefId, docRefId, null));
        }
    }

    public static void checkRpBr0090(List<ValidationError> validationErrors, String messageRefId, DocTypeEnum docType, boolean emptyTransactions, String docRefId, String xsdVersion) {
        if (!RP_BR_0090_IGNORE_VERSIONS.contains(xsdVersion) && DocTypeEnum.CESOP3.equals((Object)docType) && !emptyTransactions) {
            validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0090, messageRefId, docRefId, null));
        }
    }

    public static void checkRpBr0100(List<ValidationError> validationErrors, List<XmlCountryTypeAndValue> accounts, String messageRefId, String docRefId, String xsdVersion) {
        if (!RP_BR_0100_IGNORE_VERSIONS.contains(xsdVersion)) {
            int nbBIC = (int)accounts.stream().filter(a -> "BIC".equalsIgnoreCase(a.getType())).count();
            if (!(accounts.isEmpty() || accounts.size() <= 2 && nbBIC <= 1 && accounts.size() - nbBIC == 1)) {
                validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0100, messageRefId, docRefId, null));
            }
        }
    }

    public static void checkRpBr0110(List<ValidationError> validationErrors, String messageRefId, String type, String other, String xsdVersion) {
        if (!RP_BR_0110_IGNORE_VERSIONS.contains(xsdVersion) && "Other".equals(type)) {
            HashSet<String> wrongValues = new HashSet<String>(Arrays.asList("BIC", "IBAN", "OBAN"));
            if (other != null && wrongValues.contains(other.trim().toUpperCase())) {
                validationErrors.add(ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.RP_BR_0110, messageRefId));
            }
        }
    }

    public static void checkCmBr0150(List<ValidationError> validationErrors, String messageRefId, HashMap<Set<XmlTypeAndValue>, String> reportedPayees, List<XmlTypeAndValue> names, List<XmlCountryTypeAndValue> accounts, String docRefId) {
        List filteredNames = names.stream().filter(name -> LangUtils.isNotBlank(name.getValue())).collect(Collectors.toList());
        List filteredAccounts = accounts.stream().filter(account -> LangUtils.isNotBlank(account.getValue())).collect(Collectors.toList());
        Set reportedPayee = Stream.concat(filteredNames.stream(), filteredAccounts.stream()).collect(Collectors.toSet());
        if (!filteredNames.isEmpty() && !filteredAccounts.isEmpty() && reportedPayees.containsKey(reportedPayee)) {
            ValidationError error = ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_BR_0150, messageRefId, docRefId, null);
            String errorLongDesc = error.getErrorLongDesc();
            errorLongDesc = errorLongDesc.replace("<DocRefId1>", docRefId);
            errorLongDesc = errorLongDesc.replace("<DocRefId2>", reportedPayees.get(reportedPayee));
            error.setErrorLongDesc(errorLongDesc);
            validationErrors.add(error);
        } else {
            reportedPayees.put(reportedPayee, docRefId);
        }
    }

    public static ValidationError createCustomError(String messageRefId, String description) {
        ValidationError validationError = ValidationErrorUtils.createValidationError(ValidationErrorTypeEnum.CM_TR_9999, messageRefId);
        ValidationErrorType validationErrorType = ValidationErrorTypeHolder.INSTANCE.findByCode(ValidationErrorTypeEnum.CM_TR_9999.getCode());
        String longDescription = validationErrorType.getLongDescription() + "\n" + description;
        validationError.setErrorLongDesc(longDescription);
        return validationError;
    }

    public static ValidationError createValidationError(ValidationErrorTypeEnum errorType, String messageRefId) {
        return ValidationErrorUtils.createValidationError(errorType, messageRefId, null, null);
    }

    public static ValidationError createValidationError(ValidationErrorTypeEnum errorType, String messageRefId, String docRefId, String transactionIdentifier) {
        ValidationErrorType validationErrorType = ValidationErrorTypeHolder.INSTANCE.findByCode(errorType.getCode());
        ValidationError validationError = new ValidationError(errorType);
        validationError.setMessageRefId(messageRefId);
        validationError.setErrorCounter(1);
        validationError.setErrorShortDesc(validationErrorType.getDescription());
        validationError.setErrorLongDesc(validationErrorType.getLongDescription());
        validationError.setDocRefId(docRefId);
        validationError.setTransactionIdentifier(transactionIdentifier);
        return validationError;
    }

    public static String convertGreece(String code) {
        if (GREECE_GR.equalsIgnoreCase(code)) {
            return GREECE_EL;
        }
        return code;
    }
}

